/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client.pi;

import com.ibm.hsc.common.util.PIHscUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

class checkMulti {
    static String CEC_CIM_CLASS = "IBMHSC_ComputerSystem";
    static String CREATION_CLASS_NAME = "CreationClassName";
    static Vector inParams;
    static Vector outParams;

    checkMulti() {
    }

    static String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    static CIMObjectPath getCOP(String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(CEC_CIM_CLASS, "root/ibmhscS1_0");
        cIMObjectPath.addKey("Name", new CIMValue((Object)string));
        cIMObjectPath.addKey(CREATION_CLASS_NAME, new CIMValue((Object)CEC_CIM_CLASS));
        return cIMObjectPath;
    }

    static Vector getIOHubs(String string) {
        Object object;
        Vector vector = new Vector();
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
        try {
            object = PIHscUtil.invokeCIMMethod(checkMulti.getHostName(), checkMulti.getCOP(string), "GetIOHubs", vector, vector2);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetIOHubs method.");
            exception.printStackTrace();
            System.exit(5);
        }
        vector2.add(new CIMProperty("DRCIndex", new CIMValue(new Vector(), new CIMDataType(25))));
        vector2.add(new CIMProperty("HubType", new CIMValue(new Vector(), new CIMDataType(21))));
        object = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
        Vector vector4 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector4.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt32 unsignedInt32 = null;
        int n = -1;
        int n2 = -1;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration.nextElement();
            unsignedInt32 = (UnsignedInt32)enumeration2.nextElement();
            n = unsignedInt8.intValue();
            n2 = unsignedInt32.intValue();
            if (n == 0) {
                vector3.add(unsignedInt32);
                continue;
            }
            if (n == 1) {
                System.out.println("HubType of Infiniband found on Managed System: " + string);
                System.out.println("Infiniband DRCIndex value = " + n2);
                System.out.println("We do not need this HubType at the moment.");
                continue;
            }
            if (n == 2) {
                System.out.println("HubType of SMA found on Managed System: " + string);
                System.out.println("SMA DRCIndex value = " + n2);
                System.out.println("We do not need this HubType at the moment.");
                continue;
            }
            if (n == 255) {
                System.out.println("Error:BED1-0055:Unknown HubType on Managed System:" + string);
                System.exit(8);
                continue;
            }
            System.out.println("Error:BED1-0056:Unable to locate any I/O Hubs this system:" + string);
            System.exit(9);
        }
        return vector3;
    }

    static Vector getRioBuses(UnsignedInt32 unsignedInt32, String string, int n) {
        Object object;
        inParams = new Vector();
        CIMValue cIMValue = new CIMValue((Object)unsignedInt32, new CIMDataType(5));
        inParams.add(new CIMProperty("HubDRCIndex", cIMValue));
        outParams = new Vector();
        Vector<UnsignedInt32> vector = new Vector<UnsignedInt32>();
        try {
            object = PIHscUtil.invokeCIMMethod(checkMulti.getHostName(), checkMulti.getCOP(string), "GetRioBuses", inParams, outParams);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetRioBuses method.");
            exception.printStackTrace();
            System.exit(6);
        }
        object = (Vector)((CIMProperty)outParams.elementAt(0)).getValue().getValue();
        Vector vector2 = (Vector)((CIMProperty)outParams.elementAt(1)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector2.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt32 unsignedInt322 = null;
        int n2 = -1;
        int n3 = -1;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration2.nextElement();
            unsignedInt322 = (UnsignedInt32)enumeration.nextElement();
            n2 = unsignedInt8.intValue();
            n3 = unsignedInt322.intValue();
            if (n2 == 0) continue;
            if (n2 == 1) {
                vector.add(unsignedInt322);
                continue;
            }
            System.out.println("Unknown Bus Type");
            System.exit(10);
        }
        return vector;
    }

    static Vector getRioNodes(UnsignedInt32 unsignedInt32, String string) {
        Object object;
        inParams = new Vector();
        outParams = new Vector();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        CIMValue cIMValue = new CIMValue((Object)unsignedInt32);
        inParams.add(new CIMProperty("BusNumber", cIMValue));
        try {
            object = PIHscUtil.invokeCIMMethod(checkMulti.getHostName(), checkMulti.getCOP(string), "GetRioTopology", inParams, outParams);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetRioTopology method.");
            exception.printStackTrace();
            System.exit(7);
        }
        object = (Vector)((CIMProperty)outParams.elementAt(2)).getValue().getValue();
        Vector vector3 = (Vector)((CIMProperty)outParams.elementAt(3)).getValue().getValue();
        Vector vector4 = (Vector)((CIMProperty)outParams.elementAt(21)).getValue().getValue();
        Vector vector5 = (Vector)((CIMProperty)outParams.elementAt(15)).getValue().getValue();
        Vector vector6 = (Vector)((CIMProperty)outParams.elementAt(18)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector3.elements();
        Enumeration enumeration3 = vector4.elements();
        Enumeration enumeration4 = vector5.elements();
        Enumeration enumeration5 = vector6.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt8 unsignedInt82 = null;
        UnsignedInt8 unsignedInt83 = null;
        UnsignedInt8 unsignedInt84 = null;
        String string2 = "";
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements() && enumeration3.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration.nextElement();
            unsignedInt82 = (UnsignedInt8)enumeration2.nextElement();
            unsignedInt83 = (UnsignedInt8)enumeration4.nextElement();
            unsignedInt84 = (UnsignedInt8)enumeration5.nextElement();
            string2 = (String)enumeration3.nextElement();
            int n3 = unsignedInt8.intValue();
            int n4 = unsignedInt82.intValue();
            int n5 = unsignedInt83.intValue();
            int n6 = unsignedInt84.intValue();
            if (n3 == 1 && n4 == 0 && n5 == 1 && n6 == 1) {
                System.out.println("LeadingPortStatus = FAILED");
                System.out.println("TrailingPortStatus = FAILED");
                System.out.println("Error: A Leading and Trailing Port failure has been detected on the Local NIC on Bus Number " + unsignedInt32 + ". Unable to determine if there are any MM I/O Towers on this system.(RC=2)");
                System.exit(2);
            }
            if (n3 == 0 && n4 == 128 && string2 == null) {
                System.out.println("Error: A locally owned MM I/O Tower is set to Multihub on bus number " + unsignedInt32 + " but the EnclosureLocationCode data is null. The EnclosureLocationCode data is invalid.(RC=4)");
                System.exit(4);
            }
            if (string2 != null && string2.startsWith("UTMP")) {
                System.out.println("Enclosure Location Code is " + string2);
                System.out.println("Error:VPD is either NOT written or corrupted on this system. The node is on bus number " + unsignedInt32 + ". (RC=3)");
                System.exit(3);
            }
            if ((string2 == null || !string2.startsWith("U7311.D11")) && (string2 == null || !string2.startsWith("U1300.001"))) continue;
            if (n3 == 0 && n4 == 0) {
                ++n;
                continue;
            }
            if (n3 != 0 || n4 != 128) continue;
            ++n2;
        }
        System.out.println("Multihub Towers on bus " + unsignedInt32 + " = " + n2);
        System.out.println("Private Towers on bus " + unsignedInt32 + " = " + n);
        if (n2 > 0 && n == 0) {
            System.out.println("All Towers are set to Multihub");
            System.exit(0);
        } else if (n > 0 && n2 == 0) {
            System.out.println("All Towers are set to Private.");
            System.exit(1);
        } else if (n > 0 && n2 > 0) {
            System.out.println("Mixed: At least one Tower is set to Private and one Tower is set to Multihub.");
            System.exit(1);
        }
        return vector;
    }
}

